$(document).ready(function () {
	//Enable Tooltips
	var tooltipTriggerList = [].slice.call(
		document.querySelectorAll('[data-bs-toggle="tooltip"]')
	);
	var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
		return new bootstrap.Tooltip(tooltipTriggerEl);
	});

	//Advance Tabs
	$(".next").click(function () {
		const nextTabLinkEl = $(".nav-tabs .active")
			.closest("li")
			.next("li")
			.find("a")[0];
		const nextTab = new bootstrap.Tab(nextTabLinkEl);
		nextTab.show();
	});

	$(".previous").click(function () {
		const prevTabLinkEl = $(".nav-tabs .active")
			.closest("li")
			.prev("li")
			.find("a")[0];
		const prevTab = new bootstrap.Tab(prevTabLinkEl);
		prevTab.show();
	});
});







(function($) {

    var methods = {
        init: function(opts) {
            opts = opts || {};
            opts.tags = opts.tags || [];

            var me = $(this);
            var clean = new RegExp(',', 'g');
            me.wrap('<div class="tag-cloud" />');
            var cloud = me.parents('.tag-cloud');

            cloud.click(function() {
                me.focus();
            });

            var addTag = function(value) {
                value = value.replace(clean, '');
                if (value !== '') {
                    var tag = $('<div class="tag"><span>' + value + '</span></div>');
                    var del = $('<a href="#" class="close">Delete</a>');

                    del.click(function() {
                        del.parent().remove();
                    });
                    
                    tag.append(del);
                    tag.insertBefore(me);
                }
            }

            me.blur(function() {
                addTag(this.value);
                this.value = '';
            });
            me.keyup(function(e) {
                 var key = e.keyCode;
                var isEnter = key == 13;
                var isComma = key == 188;
                var isBack = key == 8;
                
                if (isEnter || isComma) {
                    addTag(this.value);
                    this.value = '';
                }
                if (isBack && this.data('delete-prev')) { 
                    $(this).prev().remove(); 
                    $(this).data('delete-prev',false);
                } else if(isBack && this.value === '') {
                    $(this).data('delete-prev', true); 
                    
                }
            });
            $.each(opts.tags, function(i, e) {
                addTag(e);
            });
        },
        get: function() {
            return $('.tag span',this.parent()).map(function() {
                return $(this).text();
            });
        },
        clear: function() {
            $('div', this).remove();
        }
    };
    $.fn.tagcloud = function(method) {
        if (methods[method]) {
            return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if (typeof method === 'object' || !method) {
            return methods.init.apply(this, arguments);
        } else {
            $.error('Method ' + method + ' does not exist on tagcloud plugin');
        }
    };
})(jQuery);

$('.tags').tagcloud({
    tags: ['', '', '']

});
var tags = $('.tags').tagcloud('get');







///=========Sidebars Section==============///

$(document).on("pagecreate", function() {
    $("#openSidebarButton").on("click", function() {
        $("#overlaySidebar").addClass("active");
      $("#darkOverlay").addClass("active"); // Show the dark overlay
    });

 $("#closeSidebarButton, #darkOverlay").on("click", function() {
     $("#overlaySidebar").removeClass("active");
    $("#darkOverlay").removeClass("active"); // Hide the dark overlay
   });
});



$(document).on("pagecreate", function() {
$("#openSidebarButtonAbout").on("click", function() {
$("#overlaySidebarAbout").addClass("active");
$("#darkOverlay").addClass("active"); // Show the dark overlay
});

$("#closeSidebarButtonAbout, #darkOverlay").on("click", function() {
$("#overlaySidebarAbout").removeClass("active");
$("#darkOverlay").removeClass("active"); // Hide the dark overlay
});
});



$(document).on("pagecreate", function() {
$("#openSidebarButtonReview").on("click", function() {
$("#overlaySidebarReview").addClass("active");
$("#darkOverlay").addClass("active"); // Show the dark overlay
});

$("#closeSidebarButtonReview, #darkOverlay").on("click", function() {
$("#overlaySidebarReview").removeClass("active");
$("#darkOverlay").removeClass("active"); // Hide the dark overlay
});
});
    



$(document).on("pagecreate", function() {
    $("#openSidebarButtonEvent").on("click", function() {
    $("#overlaySidebarEvent").addClass("active");
    $("#darkOverlay").addClass("active"); // Show the dark overlay
    });
    
    $("#closeSidebarButtonEvent, #darkOverlay").on("click", function() {
    $("#overlaySidebarEvent").removeClass("active");
    $("#darkOverlay").removeClass("active"); // Hide the dark overlay
    });
    });
        



    
$(document).on("pagecreate", function() {
    $("#openSidebarButtonFavorites").on("click", function() {
    $("#overlaySidebarFavorites").addClass("active");
    $("#darkOverlay").addClass("active"); // Show the dark overlay
    });
    
    $("#closeSidebarButtonFavorites, #darkOverlay").on("click", function() {
    $("#overlaySidebarFavorites").removeClass("active");
    $("#darkOverlay").removeClass("active"); // Hide the dark overlay
    });
    });



      
$(document).on("pagecreate", function() {
    $("#openSidebarButtonReward").on("click", function() {
    $("#overlaySidebarReward").addClass("active");
    $("#darkOverlay").addClass("active"); // Show the dark overlay
    });
    
    $("#closeSidebarButtonReward, #darkOverlay").on("click", function() {
    $("#overlaySidebarReward").removeClass("active");
    $("#darkOverlay").removeClass("active"); // Hide the dark overlay
    });
    });



       
$(document).on("pagecreate", function() {
    $("#openSidebarButtonChi-About").on("click", function() {
    $("#overlaySidebarChi-About").addClass("active");
    $("#darkOverlay").addClass("active"); // Show the dark overlay
    });
    
    $("#closeSidebarButtonChi-About, #darkOverlay").on("click", function() {
    $("#overlaySidebarChi-About").removeClass("active");
    $("#darkOverlay").removeClass("active"); // Hide the dark overlay
    });
    });
        


         
$(document).on("pagecreate", function() {
    $("#openSidebarButtonBusinesss-List").on("click", function() {
    $("#overlaySidebarBusiness-List").addClass("active");
    $("#darkOverlay").addClass("active"); // Show the dark overlay
    });
    
    $("#closeSidebarButtonBuiness-List, #darkOverlay").on("click", function() {
    $("#overlaySidebarBusiness-List").removeClass("active");
    $("#darkOverlay").removeClass("active"); // Hide the dark overlay
    });
    });
        