
<!DOCTYPE html>
<html lang="en">

<head>

	<title>Starlux Landing Page</title>
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<meta name="author" content="Starlux" />
	<meta name="description" content="At Starlux, we make homeownership simple, affordable, and tailored to you. 
	As a trusted name in real estate, we’re dedicated to helping you find a home that reflects your dreams and fits
	your budget. Discover a seamless journey to your ideal living space with Starlux, where quality and customer satisfaction come first.">
	<meta name="keywords" content="The best real estate in abuja.">
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />

	<!-- FAVICON AND TOUCH ICONS -->
	<link rel="shortcut icon" href="../assets/images/starlux-icon.png" type="image/x-icon">
	<link rel="icon" href="../assets/images/website_images/starlux-icon.png" type="image/x-icon">
	<link rel="apple-touch-icon" sizes="152x152" href="../assets/images/starlux-icon.png">
	<link rel="apple-touch-icon" sizes="120x120" href="../assets/images/starlux-icon.png">
	<link rel="apple-touch-icon" sizes="76x76" href="../assets/images/starlux-icon.png">
	<link rel="apple-touch-icon" href="../assets/images/starlux-icon.png">
	<link rel="icon" href="../assets/images/starlux-icon.png" type="image/x-icon">
	<link href="../assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
	<link href="../css/style.css" id="theme" rel="stylesheet">

	<!-- font awesome cn -->
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
	<link href='https://unpkg.com/boxicons@2.0.7/css/boxicons.min.css' rel='stylesheet'>
	<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/gotham-fonts@1.0.0/dist/gotham-fonts.min.css">
	<link href="https://fonts.googleapis.com/css2?family=Ubuntu:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto+Condensed:wght@400;700&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>



	<style>
		.navbarstyle {
			box-shadow: 0 2px 5px 0 #D3D3D3;
			background-color: white;
		}

		.navbar-brandimg {
			width: 205px;
			padding: 0.4%;
			margin-left: 6%;
		}

		.navbar-nav-style {
			margin-left: 10%;
		}

		.fform {
			margin-right: 4%;
		}

		.dotted-img {
			width: 120px;
			margin-top: 14%;
			margin-left: -11%;
		}

		.dotted-imgsec {
			width: 120px;
			margin-top: 2%;
			margin-left: 47%;
		}

		.aftwriteup {
			margin-left: 8%;
			margin-top: 6%;
			font-size: 17px;
			color: #3A3A3A;
		}

		.appbtn {
			border: 2px solid #007bff;
			width: 180px;
			border-radius: 10px;
			padding: 2%;
			font-weight: 550;
		}

		.startbtn {
			background-color: #007bff;
			color: white;
			width: 150px;
			border-radius: 10px;
			padding: 2%;
			font-size: 16px;
		}

		.startbtn:hover {
			color: white;
		}

		.btndiv {
			margin-left: 8%;
			margin-top: 9%;
			font-size: 17px;
		}

		.containerimg {
			display: flex;
			justify-content: center;
			align-items: center;
			padding: 0%;
		}

		.containerimg img {
			width: 120%;
			height: auto;
		}

		.home .home-text h1 {
			font-size: 35px;
			font-weight: 600;
			margin-left: 8%;
		}

		.home .home-text p {
			overflow: hidden;
		}

		.home .home-text p span {
			font-size: 30px;
			font-weight: 600;
			margin-left: 8%;
			display: inline-block;
			display: none;
		}

		.home .home-text p span.text-in {
			display: block;
			animation: textIn .5s ease;
		}

		.home .home-text p span.text-out {
			animation: textOut .5s ease;
		}

		@keyframes textIn {
			0% {
				transform: translateY(100%);
			}

			100% {
				transform: translateY(0%);
			}
		}

		@keyframes textOut {
			0% {
				transform: translateY(0%);
			}

			100% {
				transform: translateY(-100%);

			}
		}

		

		.featuretxt {
			color: #3A3A3A;
			margin-top: 10px;
			font-size: 21px;
			font-weight: 500;
			margin-left: 10%;
		}

		@media screen and (max-width: 767px) {
			.navbarstyle {
				box-shadow: none;
				background-color: white;
				width: 100%;
			}

			.navbar-brandimg {
				width: 30%;
				margin-left: 0%;
			}

			.navbar-nav-style {
				margin-left: 0%;
			}

			.startbtn {
				margin-top: 10px;
				width: 180px;
			}

			.featuretxt {
				font-size: 10px;
			}
		}

		@media only screen and (min-width: 768px) and (max-width:912px) {
			.navbarstyle {
				box-shadow: none;
				background-color: white;
				width: 100%;
			}

			.navbar-brandimg {
				width: 30%;
				margin-left: 0%;
			}

			.navbar-nav-style {
				margin-left: 0%;
			}
		}

		select:focus,
		input:focus,
		textarea:focus,
		button:focus {
			outline: none;
			border: none;
		}

		.image-container {
			display: flex;
			margin-left: 30%;
		}

		.image-container img {
			position: relative;
			margin-right: -45px;
		}

		.image-container img:last-child {
			margin-right: 0;
		}

		.image-container img:nth-child(1) {
			z-index: 6;
		}

		.image-container img:nth-child(2) {
			z-index: 5;
			left: -23px;
		}

		.image-container img:nth-child(3) {
			z-index: 4;
			left: -35px;
		}

		.image-container img:nth-child(4) {
			z-index: 3;
			left: -62px;
		}

		.image-container img:nth-child(5) {
			z-index: 2;
			left: -84px;
		}

		.image-container img:nth-child(6) {
			z-index: 1;
			left: -100px;
		}
		
		
		
		 .card {
            position: relative;
            box-shadow: rgba(149, 157, 165, 0.2) 0px 8px 24px;
            overflow: hidden;
        }

        /* Image Zoom with smooth transition */
        .zoom {
            transition: transform 0.4s ease-in-out;
        }
        
        .zoom-card:hover .zoom {
            transform: scale(1.05);
        }

        /* Overlay for the card */
        .card-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 50%;
            background-color: rgba(0, 0, 0, 0.6); /* Darker overlay */
            opacity: 0;
            transition: opacity 0.4s ease-in-out;
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        /* Hover effects for zoom and overlay */
        .card:hover .zoom {
            transform: scale(1.1);
        }

        .card:hover .card-overlay {
            opacity: 1;
        }

        /* Responsive adjustments for smaller screens */
        @media (max-width: 768px) {
            .card:hover .zoom {
                transform: scale(1.05);
            }
            .card-overlay {
                font-size: 1rem;
            }
        }

        @media (max-width: 576px) {
            .card:hover .zoom {
                transform: scale(1.02);
            }
            .card-overlay {
                font-size: 0.9rem;
            }
        }
	</style>

   <style>
         /* Hero Section Styling */
        .hero-section {
        
          padding: 100px 0;
        }
        
        /* Landscape iPad Video Container */
        .ipad-video-container {
          display: flex;
          justify-content: center;
          align-items: center;
        }
        
        .ipad-frame {
          position: relative;
          width: 950px;
          height: 500px; /* Landscape orientation */
          background: #333;
          border-radius: 5px;
          overflow: hidden;
          box-shadow: 0 10px 20px rgba(0, 0, 0, 0.3);
        }
        
        /* iPad Top and Bottom Elements */
        .ipad-frame::before {
          content: '';
          position: absolute;
          top: 10px;
          left: 50%;
          transform: translateX(-50%);
          width: 40px;
          height: 4px;
          background-color: #555;
          border-radius: 10px;
        }
        
        .ipad-frame::after {
          content: '';
          position: absolute;
          bottom: 15px;
          left: 50%;
          transform: translateX(-50%);
          width: 30px;
          height: 30px;
          background-color: #444;
          border-radius: 50%;
        }
        
        /* Video Styling */
        .video {
          position: absolute;
          top: 0;
          left: 0;
          width: 100%;
          height: 100%;
          border-radius: 10px;
        }
        
        /* Button Styling */
        .learn-more-btn {
          background-color: #007bff;
          font-family: 'Space Grotesk', sans-serif;
          padding: 10px 20px;
          border-radius: 5px;
        }
        
        /* Preheading and Headline Section Styling */
        .property-hero {
          background-color: #f8f9fa;
          padding: 40px 0;
        }
        
        .preheading {
           font-family: 'Montserrat', sans-serif;
            color: #FFF;
            font-size: 1.5rem; /* Decrease the font size */
            font-weight: 700;
            margin-bottom: 10px;
            background-color: #E4B533; /* Set the background color */
            padding: 10px 15px 10px 15px; /* Adjust padding to fit the text */
            display: inline-block; /* Makes the background fit the text */
            border-radius: 5px; /* Optional: rounds the corners */
                  
          
        }
        
        .headline {
          font-family: "Roboto Condensed", sans-serif;
           line-height: 100%;
          color: #333;
          font-size: 4.2rem;
          font-weight: 700;
          max-width: 1000px;
          margin: 0 auto;
        }
        
        .location {
          color: #E4B533;
          text-decoration: underline;
        }
        
        /* Responsive Adjustments */
        @media (max-width: 768px) {
          .preheading {
            font-size: 1.2rem;
          }
        
          .headline {
            font-size: 2rem;
          }
        }
        
        @media (max-width: 576px) {
          .headline {
            font-size: 1.8rem;
          }
        }
        
        /* Styling for Subheadline */
            .subheadline {
              font-family: 'Montserrat', sans-serif;
              color: #555;
              font-weight: medium;
              font-size: 1.25rem;
              max-width: 750px;
              margin: 20px auto 0;
            }
            
            @media (max-width: 768px) {
              .subheadline {
                font-size: 1.1rem;
              }
            }
            
            @media (max-width: 576px) {
              .subheadline {
                font-size: 1rem;
              }
            }
            
            
            
            /* Responsive Adjustments */
            @media (max-width: 768px) {
              .cta-button {
                font-size: 1rem;
                padding: 12px 25px;
              }
            }

        
        .reg-btn {
        	font-size: 30px;
    
        	color: #fff;
        	font-family: 'Montserrat', sans-serif;
        	text-transform: capitalize;
        	font-weight: bold;
        	border-radius: 7px;
        	border: 1px solid #9e1700;
        	border-bottom: 5px solid #9e1700;
        	display: inline-block;
        	padding: 20px 45px;
        	text-align: center;
        	background: #f83515;
            background: -moz-linear-gradient(top, #f83515 0%, #d62203 100%);
            background: -webkit-linear-gradient(top, #f83515 0%,#d62203 100%);
            background: linear-gradient(to bottom, #f83515 0%,#d62203 100%);
        	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#f83515', endColorstr='#d62203',GradientType=0 );
        	-moz-transition: all 0.3s ease;
        	-o-transition: all 0.3s ease;
        	-webkit-transition: all 0.3s ease;
        	-ms-transition: all 0.3s ease;
        	transition: all 0.3s ease;
        	
        }
        .reg-btn:hover {
        	background: #9e1700;
            color: #fff;
        }
        
        .reg-btn span {
        	display: block;
        	font-size: 15px;
        	font-weight: 600;
        	text-transform: none;
        	font-style: italic;
        }
        
        
                    
            /* Responsive Adjustments */
            @media (max-width: 1024px) {
              .reg-btn {
                font-size: 24px;
                padding: 25px 45px;
              }
            }
            
            @media (max-width: 768px) {
              .reg-btn {
                font-size: 20px;
                padding: 20px 40px;
              }
            }
            
            @media (max-width: 480px) {
              .reg-btn {
                font-size: 18px;
                padding: 15px 30px;
              }
              .reg-btn span {
                font-size: 14px;
              }
            }
     
    
     .property-carousel, .app-carousel {
            display: none;
        }
    
        /* Desktop view: show property carousel, hide mobile carousel */
        @media (min-width: 768px) {
            .property-carousel {
                display: block;
            }
        }
    
        /* Mobile view: show mobile carousel, hide property carousel */
        @media (max-width: 767px) {
            .app-carousel {
                display: block;
            }
            
            .bait-image{
                 display: none !important;
            }
        }
      

   </style>
    
    
     <style media="screen">

#slider {
  position: relative;
  width: 50%;
  height: 32vw;
  margin: 150px auto;
  font-family: 'Helvetica Neue', sans-serif;
  perspective: 1400px;
  transform-style: preserve-3d;
}

input[type=radio] {
  position: relative;
  top: 108%;
  left: 50%;
  width: 18px;
  height: 18px;
  margin: 0 15px 0 0;
  opacity: 0.4;
  transform: translateX(-83px);
  cursor: pointer;
}


input[type=radio]:nth-child(5) {
  margin-right: 0px;
}

input[type=radio]:checked {
  opacity: 1;
}




#slider label,
#slider label img {
  position: absolute;
  width: 100%;
  height: 100%;
  left: 0;
  top: 0;
  color: white;
  font-size: 70px;
  font-weight: bold;
  border-radius: 3px;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: transform 400ms ease;
}



/* Slider Functionality */

/* Active Slide */
#s1:checked ~ #slide1,
 #s2:checked ~ #slide2,
  #s3:checked ~ #slide3,
   #s4:checked ~ #slide4,
    #s5:checked ~ #slide5 {
  box-shadow: 0 13px 26px rgba(0,0,0, 0.3), 0 12px 6px rgba(0,0,0, 0.2);
  transform: translate3d(0%, 0, 0px);
}

/* Next Slide */
#s1:checked ~ #slide2,
 #s2:checked ~ #slide3,
  #s3:checked ~ #slide4,
   #s4:checked ~ #slide5,
    #s5:checked ~ #slide1 {
  box-shadow: 0 6px 10px rgba(0,0,0, 0.3), 0 2px 2px rgba(0,0,0, 0.2);
  transform: translate3d(20%, 0, -100px);
}


/* Next to Next Slide */
#s1:checked ~ #slide3,
 #s2:checked ~ #slide4,
  #s3:checked ~ #slide5,
   #s4:checked ~ #slide1,
    #s5:checked ~ #slide2 {
  box-shadow: 0 1px 4px rgba(0,0,0, 0.4);
  transform: translate3d(40%, 0, -250px);
}

/* Previous to Previous Slide */
#s1:checked ~ #slide4,
 #s2:checked ~ #slide5,
  #s3:checked ~ #slide1,
   #s4:checked ~ #slide2,
    #s5:checked ~ #slide3 {
  box-shadow: 0 1px 4px rgba(0,0,0, 0.4);
  transform: translate3d(-40%, 0, -250px);
}

/* Previous Slide */
#s1:checked ~ #slide5,
 #s2:checked ~ #slide1,
  #s3:checked ~ #slide2,
   #s4:checked ~ #slide3,
    #s5:checked ~ #slide4 {
  box-shadow: 0 6px 10px rgba(0,0,0, 0.3), 0 2px 2px rgba(0,0,0, 0.2);
  transform: translate3d(-20%, 0, -100px);
}


  </style>

</head>

<body>

	<main>

			<!--==============================================-->
			<!---===============Heaader Section===============-->
		    <!--<nav class="navbar navbar-expand-lg " style="background-color: #f8f9fa; padding-bottom: 10px;">
                <div class="container">
                    <a class="navbar-brand" href="../index.php">
                        <img class="navbar-brandimg img-fluid" style="width: 100px; height: auto;" src="../assets/images/starlux.png" />
                    </a>
                    <button class="navbar-toggler btn btn-link" style="text-decoration: none;" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                        <i class="material-icons" style="font-size: 35px; color: #fff;" aria-hidden="true">menu</i>
                    </button>
            
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav tebheaderlink justify-content-center mr-auto navbar-nav-style me-auto mb-2 mb-lg-0">
                           <li></li>
                        
                        </ul>
                        <form class="d-flex">
                            <a href="#"  data-bs-toggle="modal" data-bs-target="#staticBackdrop" class="btn btn-outline-danger tebheaderButton" style="background: red; font-size: 15px;" type="submit">Find Your Dream Home Now!!!</a>
                        </form>
                    </div>
                </div>
            </nav>-->
            <!--==============================================-->
			<!---===============Heaader Section===============-->
            
            
            <section class="property-hero hero-section text-center py-5" style=" margin-top: -30px; " role="banner">
                <div class="container">
                    <h3 class="preheading alert alert-danger" role="alert">
                       
                        Looking for Your Dream Property?
                    </h3>
                    <h1 class="headline">
                        Discover Your Ideal Home in <span class="location">Abuja</span>!! Get Exclusive Access to the Best Properties in the Market
                    </h1>
                    
                    <p class="subheadline">
                        Find the perfect home or investment property that fits your needs and budget. Let our experts guide you every step of the way!
                    </p>
                    
                    <!-- iPad Landscape Video Container -->
                     <div class="ipad-video-container mt-4 mb-5">
                        <div class="ipad-frame">
                            <iframe class="video" src="https://www.youtube.com/embed/Rw-B_jm-rX4" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen aria-label="Promotional video about properties in Abuja"></iframe>
                        </div>
                    </div>
                    
                    <button class="reg-btn mt-5"  class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#staticBackdrop">
                        Find Your Dream Home Now!!! <span>Get Instant Access to New Listing</span>
                    </button>
                </div>
            </section>
            
          
            
            <div class="container-fluid p-3" style="margin-top: 70px;">
                <div class="row pt-2">
                    <div class="col-lg-12">
                        <h1 align="center" style="font-family: 'Ubuntu', sans-serif;">Featured Properties</h1>
                    </div>
                    <div class="col-lg-2"></div>
                    <div class="col-lg-8">
                        <p align="center" style="font-family: 'Space Grotesk', sans-serif; color: black; padding: 20px 50px 0px 50px;">
                            Discover our handpicked properties that blend lifestyle, comfort, and affordability – your perfect home awaits with Starlux.
                        </p>
                    </div>
                    <div class="col-lg-2"></div>
                </div> <!-- Closed the first row div correctly -->
            
                <section id="slider" style="margin-top: 10px;">
                  <input type="radio" name="slider" id="s1" checked>
                  <input type="radio" name="slider" id="s2">
                  <input type="radio" name="slider" id="s3">
                  <input type="radio" name="slider" id="s4">
                  <input type="radio" name="slider" id="s5">
                
                  <label for="s1" data-bs-toggle="modal" data-bs-target="#staticBackdrop" id="slide1"><img src="../assets/images/property-bait/1.jpg" alt=""></label>
                  <label for="s2" data-bs-toggle="modal" data-bs-target="#staticBackdrop" id="slide2"><img src="../assets/images/property-bait/2.jpg" alt=""></label>
                  <label for="s3" data-bs-toggle="modal" data-bs-target="#staticBackdrop" id="slide3"><img src="../assets/images/property-bait/3.jpg" alt=""></label>
                  <label for="s4" data-bs-toggle="modal" data-bs-target="#staticBackdrop" id="slide4"><img src="../assets/images/property-bait/4.jpg" alt=""></label>
                  <label for="s5" data-bs-toggle="modal" data-bs-target="#staticBackdrop" id="slide5"><img src="../assets/images/property-bait/5.jpg" alt=""></label>
                </section>
            </div>

            
            
            
            
            <div class="container">
                  
                    <!--==============================================-->
                    <!--===========Desktop View Properties Listing==============-->    
                
                    <section class="property-carousel"  style="padding-bottom: 200px;">
                        <div id="carouselExampleInterval" class="carousel slide" data-bs-ride="carousel">
                            
                              <div class="carousel-inner">
                                  
                                <div class="carousel-item active" data-bs-interval="5000">
                                  
                                   <div class="row g-4 pt-2">
                                       <div class="col-lg-4 col-md-4 col-sm-12">
                                            <a href="#" data-bs-toggle="modal" data-bs-target="#staticBackdrop" style="text-decoration: none; color: black">
                                                <div class="card zoom-card" style="width: 100%; box-shadow: rgba(149, 157, 165, 0.2) 0px 8px 24px;">
                                                    <div style="position: relative;">
                                                        <img src="../assets/images/house1.jpg" class="card-img-top zoom" alt="...">
                                                        
                                                        <div class="overlay-content zoom" style="position: absolute; top: 0; left: 0; right: 0; height: 100%; background-color: rgba(0, 0, 0, 0.4); color: white; display: flex; z-index: 10; transition: transform 0.4s ease-in-out;">
                                                            <div class="status-badge" style="position: absolute; top: 10px; right: 10px; background-color: red; color: white; padding: 5px 10px; border-radius: 5px; font-size: 12px; z-index: 11;">
                                                                For Sale
                                                            </div>
                                                            <p style="padding: 20px; margin-top: 195px;"><i class="fa-solid fa-location-dot"></i> Wuse II, Abuja, Abuja FCT</p>
                                                        </div>
                                                    </div>
                                        
                                                    <div class="card-body">
                                                        <h5 class="card-title mt-3" style="font-family: 'Space Grotesk' !important;">Brand New Luxury 4 Bedroom Duplex at Wuse 2</h5>
                                                        
                                                        <h6 class="feature-figure-text">₦ 150,000,000</h6>
                                                        
                                                        <p class="card-text mt-4" style="font-size: 14px; font-family: 'Space Grotesk' !important; font-weight: 400;">
                                                            Brand new Luxury 6 bedroom mansion with green area is available for sale at Katampe extension district Abuja
                                                        </p>
                                                        
                                                        <div class="row p-3 g-3">
                                                            <div class="col-4 col-lg-4 col-md-3" style="border-right: 1px solid #d6ccc2;">
                                                                3 <i class="fa-solid fa-bed" style="color: #707070;"></i>
                                                                 <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                        	                       Bedrooms
                                        	                     </p>
                                                                
                                                            </div>
                                                            <div class="col-4 col-lg-4 col-md-3"  style="border-right: 1px solid #d6ccc2;">
                                                                2 <i class="fa-solid fa-bath" style="color: #707070;"></i>
                                                                 <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                        	                       Bathrooms
                                        	                     </p>
                                                            </div>
                                                            <div class="col-4 col-lg-4 col-md-3"  style="border-right: 1px solid #d6ccc2;">
                                                                3450 <i class="fa-regular fa-square" style="color: #707070;"></i>
                                                                 <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                        	                       Squard Ft
                                        	                     </p>
                                                            </div>
                                                            
                                                        </div>
                                                        
                                                        <hr>
                                                        
                                                        <a href="#"  data-bs-toggle="modal" data-bs-target="#staticBackdrop" class="btn btn-warning tebHeroBtnHot btn-sm ">See Property</a>
                                                    </div>
                                                </div>
                                            </a>
                                       </div>
                                       
                                       <div class="col-lg-4 col-md-4 col-sm-12">
                                            <a href="#" style="text-decoration: none; color: black" data-bs-toggle="modal" data-bs-target="#staticBackdrop">
                                                <div class="card zoom-card" style="width: 100%; box-shadow: rgba(149, 157, 165, 0.2) 0px 8px 24px;">
                                                    <div style="position: relative;">
                                                        <img src="../assets/images/house2.jpg" class="card-img-top zoom" alt="...">
                                                        
                                                        <div class="overlay-content zoom" style="position: absolute; top: 0; left: 0; right: 0; height: 100%; background-color: rgba(0, 0, 0, 0.4); color: white; display: flex; z-index: 10; transition: transform 0.4s ease-in-out;">
                                                            <div class="status-badge" style="position: absolute; top: 10px; right: 10px; background-color: red; color: white; padding: 5px 10px; border-radius: 5px; font-size: 12px; z-index: 11;">
                                                                For Sale
                                                            </div>
                                                            <p style="padding: 20px; margin-top: 195px;"><i class="fa-solid fa-location-dot"></i> Wuse II, Abuja, Abuja FCT</p>
                                                        </div>
                                                    </div>
                                        
                                                    <div class="card-body">
                                                        <h5 class="card-title mt-3" style="font-family: 'Space Grotesk' !important;">Brand New Luxury 4 Bedroom Duplex at Wuse 2</h5>
                                                        
                                                        <h6 class="feature-figure-text">₦ 150,000,000</h6>
                                                        
                                                        <p class="card-text mt-4" style="font-size: 14px; font-family: 'Space Grotesk' !important; font-weight: 400;">
                                                            Brand new Luxury 6 bedroom mansion with green area is available for sale at Katampe extension district Abuja
                                                        </p>
                                                        
                                                          <div class="row p-3 g-3">
                                                            <div class="col-4 col-lg-4 col-md-3" style="border-right: 1px solid #d6ccc2;">
                                                                3 <i class="fa-solid fa-bed" style="color: #707070;"></i>
                                                                 <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                        	                       Bedrooms
                                        	                     </p>
                                                                
                                                            </div>
                                                            <div class="col-4 col-lg-4 col-md-3"  style="border-right: 1px solid #d6ccc2;">
                                                                2 <i class="fa-solid fa-bath" style="color: #707070;"></i>
                                                                 <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                        	                       Bathrooms
                                        	                     </p>
                                                            </div>
                                                            <div class="col-4 col-lg-4 col-md-3"  style="border-right: 1px solid #d6ccc2;">
                                                                3450 <i class="fa-regular fa-square" style="color: #707070;"></i>
                                                                 <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                        	                       Squard Ft
                                        	                     </p>
                                                            </div>
                                                            
                                                        </div>
                                                        
                                                        <hr>
                                                        
                                                        
                                                        <a href="#"  data-bs-toggle="modal" data-bs-target="#staticBackdrop" class="btn btn-warning tebHeroBtnHot btn-sm">See Property</a>
                                                    </div>
                                                </div>
                                            </a>
                                       </div>
                                       
                                       <div class="col-lg-4 col-md-4 col-sm-12">
                                            <a href="#" style="text-decoration: none; color: black"  data-bs-toggle="modal" data-bs-target="#staticBackdrop">
                                                <div class="card zoom-card" style="width: 100%; box-shadow: rgba(149, 157, 165, 0.2) 0px 8px 24px;">
                                                    <div style="position: relative;">
                                                        <img src="../assets/images/house3.jpg" class="card-img-top zoom" alt="...">
                                                        
                                                        <div class="overlay-content zoom" style="position: absolute; top: 0; left: 0; right: 0; height: 100%; background-color: rgba(0, 0, 0, 0.4); color: white; display: flex; z-index: 10; transition: transform 0.4s ease-in-out;">
                                                            <div class="status-badge" style="position: absolute; top: 10px; right: 10px; background-color: red; color: white; padding: 5px 10px; border-radius: 5px; font-size: 12px; z-index: 11;">
                                                                For Sale
                                                            </div>
                                                            <p style="padding: 20px; margin-top: 195px;"><i class="fa-solid fa-location-dot"></i> Wuse II, Abuja, Abuja FCT</p>
                                                        </div>
                                                    </div>
                                        
                                                    <div class="card-body">
                                                        <h5 class="card-title mt-3" style="font-family: 'Space Grotesk' !important;">Brand New Luxury 4 Bedroom Duplex at Wuse 2</h5>
                                                        
                                                        <h6 class="feature-figure-text">₦ 150,000,000</h6>
                                                        
                                                        <p class="card-text mt-4" style="font-size: 14px; font-family: 'Space Grotesk' !important; font-weight: 400;">
                                                            Brand new Luxury 6 bedroom mansion with green area is available for sale at Katampe extension district Abuja
                                                        </p>
                                                        
                                                          <div class="row p-3 g-3">
                                                            <div class="col-4 col-lg-4 col-md-3" style="border-right: 1px solid #d6ccc2;">
                                                                3 <i class="fa-solid fa-bed" style="color: #707070;"></i>
                                                                 <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                        	                       Bedrooms
                                        	                     </p>
                                                                
                                                            </div>
                                                            <div class="col-4 col-lg-4 col-md-3"  style="border-right: 1px solid #d6ccc2;">
                                                                2 <i class="fa-solid fa-bath" style="color: #707070;"></i>
                                                                 <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                        	                       Bathrooms
                                        	                     </p>
                                                            </div>
                                                            <div class="col-4 col-lg-4 col-md-3"  style="border-right: 1px solid #d6ccc2;">
                                                                3450 <i class="fa-regular fa-square" style="color: #707070;"></i>
                                                                 <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                        	                       Squard Ft
                                        	                     </p>
                                                            </div>
                                                            
                                                        </div>
                                                        
                                                        <hr>
                                                        
                                                        
                                                        <a href="#"  data-bs-toggle="modal" data-bs-target="#staticBackdrop" class="btn btn-warning tebHeroBtnHot btn-sm">See Property</a>
                                                    </div>
                                                </div>
                                            </a>
                                       </div>
                                       
                                   </div>
                                  
                                </div>
                                <div class="carousel-item" data-bs-interval="3000">
                                  
                                    <div class="row g-4 pt-5">
                                       <div class="col-lg-4 col-md-4 col-sm-12">
                                            <a href="#"  data-bs-toggle="modal" data-bs-target="#staticBackdrop" style="text-decoration: none; color: black">
                                                <div class="card zoom-card" style="width: 100%; box-shadow: rgba(149, 157, 165, 0.2) 0px 8px 24px;">
                                                    <div style="position: relative;">
                                                        <img src="../assets/images/house1.jpg" class="card-img-top zoom" alt="...">
                                                        
                                                        <div class="overlay-content zoom" style="position: absolute; top: 0; left: 0; right: 0; height: 100%; background-color: rgba(0, 0, 0, 0.4); color: white; display: flex; z-index: 10; transition: transform 0.4s ease-in-out;">
                                                            <div class="status-badge" style="position: absolute; top: 10px; right: 10px; background-color: red; color: white; padding: 5px 10px; border-radius: 5px; font-size: 12px; z-index: 11;">
                                                                For Sale
                                                            </div>
                                                            <p style="padding: 20px; margin-top: 195px;"><i class="fa-solid fa-location-dot"></i> Wuse II, Abuja, Abuja FCT</p>
                                                        </div>
                                                    </div>
                                        
                                                    <div class="card-body">
                                                        <h5 class="card-title mt-3" style="font-family: 'Space Grotesk' !important;">Brand New Luxury 4 Bedroom Duplex at Wuse 2</h5>
                                                        
                                                        <h6 class="feature-figure-text">₦ 150,000,000</h6>
                                                        
                                                        <p class="card-text mt-4" style="font-size: 14px; font-family: 'Space Grotesk' !important; font-weight: 400;">
                                                            Brand new Luxury 6 bedroom mansion with green area is available for sale at Katampe extension district Abuja
                                                        </p>
                                                        
                                                        <div class="row p-3 g-3">
                                                            <div class="col-4 col-lg-4 col-md-3" style="border-right: 1px solid #d6ccc2;">
                                                                3 <i class="fa-solid fa-bed" style="color: #707070;"></i>
                                                                 <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                        	                       Bedrooms
                                        	                     </p>
                                                                
                                                            </div>
                                                            <div class="col-4 col-lg-4 col-md-3"  style="border-right: 1px solid #d6ccc2;">
                                                                2 <i class="fa-solid fa-bath" style="color: #707070;"></i>
                                                                 <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                        	                       Bathrooms
                                        	                     </p>
                                                            </div>
                                                            <div class="col-4 col-lg-4 col-md-3"  style="border-right: 1px solid #d6ccc2;">
                                                                3450 <i class="fa-regular fa-square" style="color: #707070;"></i>
                                                                 <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                        	                       Squard Ft
                                        	                     </p>
                                                            </div>
                                                            
                                                        </div>
                                                        
                                                        <hr>
                                                        
                                                        <a href="#"  data-bs-toggle="modal" data-bs-target="#staticBackdrop" class="btn btn-warning tebHeroBtnHot btn-sm ">See Property</a>
                                                    </div>
                                                </div>
                                            </a>
                                       </div>
                                       
                                       <div class="col-lg-4 col-md-4 col-sm-12">
                                            <a href="#"  data-bs-toggle="modal" data-bs-target="#staticBackdrop" style="text-decoration: none; color: black">
                                                <div class="card zoom-card" style="width: 100%; box-shadow: rgba(149, 157, 165, 0.2) 0px 8px 24px;">
                                                    <div style="position: relative;">
                                                        <img src="../assets/images/house2.jpg" class="card-img-top zoom" alt="...">
                                                        
                                                        <div class="overlay-content zoom" style="position: absolute; top: 0; left: 0; right: 0; height: 100%; background-color: rgba(0, 0, 0, 0.4); color: white; display: flex; z-index: 10; transition: transform 0.4s ease-in-out;">
                                                            <div class="status-badge" style="position: absolute; top: 10px; right: 10px; background-color: red; color: white; padding: 5px 10px; border-radius: 5px; font-size: 12px; z-index: 11;">
                                                                For Sale
                                                            </div>
                                                            <p style="padding: 20px; margin-top: 195px;"><i class="fa-solid fa-location-dot"></i> Wuse II, Abuja, Abuja FCT</p>
                                                        </div>
                                                    </div>
                                        
                                                    <div class="card-body">
                                                        <h5 class="card-title mt-3" style="font-family: 'Space Grotesk' !important;">Brand New Luxury 4 Bedroom Duplex at Wuse 2</h5>
                                                        
                                                        <h6 class="feature-figure-text">₦ 150,000,000</h6>
                                                        
                                                        <p class="card-text mt-4" style="font-size: 14px; font-family: 'Space Grotesk' !important; font-weight: 400;">
                                                            Brand new Luxury 6 bedroom mansion with green area is available for sale at Katampe extension district Abuja
                                                        </p>
                                                        
                                                          <div class="row p-3 g-3">
                                                            <div class="col-4 col-lg-4 col-md-3" style="border-right: 1px solid #d6ccc2;">
                                                                3 <i class="fa-solid fa-bed" style="color: #707070;"></i>
                                                                 <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                        	                       Bedrooms
                                        	                     </p>
                                                                
                                                            </div>
                                                            <div class="col-4 col-lg-4 col-md-3"  style="border-right: 1px solid #d6ccc2;">
                                                                2 <i class="fa-solid fa-bath" style="color: #707070;"></i>
                                                                 <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                        	                       Bathrooms
                                        	                     </p>
                                                            </div>
                                                            <div class="col-4 col-lg-4 col-md-3"  style="border-right: 1px solid #d6ccc2;">
                                                                3450 <i class="fa-regular fa-square" style="color: #707070;"></i>
                                                                 <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                        	                       Squard Ft
                                        	                     </p>
                                                            </div>
                                                            
                                                        </div>
                                                        
                                                        <hr>
                                                        
                                                        
                                                        <a href="#"  data-bs-toggle="modal" data-bs-target="#staticBackdrop" class="btn btn-warning tebHeroBtnHot btn-sm">See Property</a>
                                                    </div>
                                                </div>
                                            </a>
                                       </div>
                                       
                                       <div class="col-lg-4 col-md-4 col-sm-12">
                                            <a href="#"  data-bs-toggle="modal" data-bs-target="#staticBackdrop" style="text-decoration: none; color: black">
                                                <div class="card zoom-card" style="width: 100%; box-shadow: rgba(149, 157, 165, 0.2) 0px 8px 24px;">
                                                    <div style="position: relative;">
                                                        <img src="../assets/images/house3.jpg" class="card-img-top zoom" alt="...">
                                                        
                                                        <div class="overlay-content zoom" style="position: absolute; top: 0; left: 0; right: 0; height: 100%; background-color: rgba(0, 0, 0, 0.4); color: white; display: flex; z-index: 10; transition: transform 0.4s ease-in-out;">
                                                            <div class="status-badge" style="position: absolute; top: 10px; right: 10px; background-color: red; color: white; padding: 5px 10px; border-radius: 5px; font-size: 12px; z-index: 11;">
                                                                For Sale
                                                            </div>
                                                            <p style="padding: 20px; margin-top: 195px;"><i class="fa-solid fa-location-dot"></i> Wuse II, Abuja, Abuja FCT</p>
                                                        </div>
                                                    </div>
                                        
                                                    <div class="card-body">
                                                        <h5 class="card-title mt-3" style="font-family: 'Space Grotesk' !important;">Brand New Luxury 4 Bedroom Duplex at Wuse 2</h5>
                                                        
                                                        <h6 class="feature-figure-text">₦ 150,000,000</h6>
                                                        
                                                        <p class="card-text mt-4" style="font-size: 14px; font-family: 'Space Grotesk' !important; font-weight: 400;">
                                                            Brand new Luxury 6 bedroom mansion with green area is available for sale at Katampe extension district Abuja
                                                        </p>
                                                        
                                                          <div class="row p-3 g-3">
                                                            <div class="col-4 col-lg-4 col-md-3" style="border-right: 1px solid #d6ccc2;">
                                                                3 <i class="fa-solid fa-bed" style="color: #707070;"></i>
                                                                 <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                        	                       Bedrooms
                                        	                     </p>
                                                                
                                                            </div>
                                                            <div class="col-4 col-lg-4 col-md-3"  style="border-right: 1px solid #d6ccc2;">
                                                                2 <i class="fa-solid fa-bath" style="color: #707070;"></i>
                                                                 <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                        	                       Bathrooms
                                        	                     </p>
                                                            </div>
                                                            <div class="col-4 col-lg-4 col-md-3"  style="border-right: 1px solid #d6ccc2;">
                                                                3450 <i class="fa-regular fa-square" style="color: #707070;"></i>
                                                                 <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                        	                       Squard Ft
                                        	                     </p>
                                                            </div>
                                                            
                                                        </div>
                                                        
                                                        <hr>
                                                        
                                                        
                                                        <a href="#"  data-bs-toggle="modal" data-bs-target="#staticBackdrop" class="btn btn-warning tebHeroBtnHot btn-sm">See Property</a>
                                                    </div>
                                                </div>
                                            </a>
                                       </div>
                                       
                                   </div>
                                    
                                </div>
                                
                              </div>
                          
                          
                              <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleInterval" data-bs-slide="prev">
                                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                <span class="visually-hidden">Previous</span>
                              </button>
                              <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleInterval" data-bs-slide="next">
                                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                <span class="visually-hidden">Next</span>
                              </button>
                              
                        </div>
                    </section>
                    
                    
                    
                    <!--==============================================-->
                    <!--===========Mobile View Properties Listing==============-->  
                    <!-- Carousel Section -->
                    <section class="app-carousel">
                        <div id="carouselExampleSlidesOnly" class="carousel slide" data-bs-ride="carousel">
                              <div class="carousel-inner">
                                <div class="carousel-item active">
                                    <a href="#"  data-bs-toggle="modal" data-bs-target="#staticBackdrop" style="text-decoration: none; color: black">
                                        <div class="card zoom-card" style="width: 100%; box-shadow: rgba(149, 157, 165, 0.2) 0px 8px 24px;">
                                            <div style="position: relative;">
                                                <img src="../assets/images/house2.jpg" class="card-img-top zoom" alt="...">
                                                
                                                <div class="overlay-content zoom" style="position: absolute; top: 0; left: 0; right: 0; height: 100%; background-color: rgba(0, 0, 0, 0.4); color: white; display: flex; z-index: 10; transition: transform 0.4s ease-in-out;">
                                                    <div class="status-badge" style="position: absolute; top: 10px; right: 10px; background-color: red; color: white; padding: 5px 10px; border-radius: 5px; font-size: 12px; z-index: 11;">
                                                        For Sale
                                                    </div>
                                                    <p style="padding: 20px; margin-top: 195px;"><i class="fa-solid fa-location-dot"></i> Wuse II, Abuja, Abuja FCT</p>
                                                </div>
                                            </div>
                                
                                            <div class="card-body">
                                                <h5 class="card-title mt-3" style="font-family: 'Space Grotesk' !important;">Brand New Luxury 4 Bedroom Duplex at Wuse 2</h5>
                                                
                                                <h6 class="feature-figure-text">₦ 150,000,000</h6>
                                                
                                                <p class="card-text mt-4" style="font-size: 14px; font-family: 'Space Grotesk' !important; font-weight: 400;">
                                                    Brand new Luxury 6 bedroom mansion with green area is available for sale at Katampe extension district Abuja
                                                </p>
                                                
                                                  <div class="row p-3 g-3">
                                                    <div class="col-4 col-lg-4 col-md-3" style="border-right: 1px solid #d6ccc2;">
                                                        3 <i class="fa-solid fa-bed" style="color: #707070;"></i>
                                                         <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                	                       Bedrooms
                                	                     </p>
                                                        
                                                    </div>
                                                    <div class="col-4 col-lg-4 col-md-3"  style="border-right: 1px solid #d6ccc2;">
                                                        2 <i class="fa-solid fa-bath" style="color: #707070;"></i>
                                                         <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                	                       Bathrooms
                                	                     </p>
                                                    </div>
                                                    <div class="col-4 col-lg-4 col-md-3"  style="border-right: 1px solid #d6ccc2;">
                                                        3450 <i class="fa-regular fa-square" style="color: #707070;"></i>
                                                         <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                	                       Squard Ft
                                	                     </p>
                                                    </div>
                                                    
                                                </div>
                                                
                                                <hr>
                                                
                                                
                                                <a href="#"  data-bs-toggle="modal" data-bs-target="#staticBackdrop" class="btn btn-warning tebHeroBtnHot btn-sm">See Property</a>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                                <div class="carousel-item">
                                    <a href="#"  data-bs-toggle="modal" data-bs-target="#staticBackdrop" style="text-decoration: none; color: black">
                                        <div class="card zoom-card" style="width: 100%; box-shadow: rgba(149, 157, 165, 0.2) 0px 8px 24px;">
                                            <div style="position: relative;">
                                                <img src="../assets/images/house2.jpg" class="card-img-top zoom" alt="...">
                                                
                                                <div class="overlay-content zoom" style="position: absolute; top: 0; left: 0; right: 0; height: 100%; background-color: rgba(0, 0, 0, 0.4); color: white; display: flex; z-index: 10; transition: transform 0.4s ease-in-out;">
                                                    <div class="status-badge" style="position: absolute; top: 10px; right: 10px; background-color: red; color: white; padding: 5px 10px; border-radius: 5px; font-size: 12px; z-index: 11;">
                                                        For Sale
                                                    </div>
                                                    <p style="padding: 20px; margin-top: 195px;"><i class="fa-solid fa-location-dot"></i> Wuse II, Abuja, Abuja FCT</p>
                                                </div>
                                            </div>
                                
                                            <div class="card-body">
                                                <h5 class="card-title mt-3" style="font-family: 'Space Grotesk' !important;">Brand New Luxury 4 Bedroom Duplex at Wuse 2</h5>
                                                
                                                <h6 class="feature-figure-text">₦ 150,000,000</h6>
                                                
                                                <p class="card-text mt-4" style="font-size: 14px; font-family: 'Space Grotesk' !important; font-weight: 400;">
                                                    Brand new Luxury 6 bedroom mansion with green area is available for sale at Katampe extension district Abuja
                                                </p>
                                                
                                                  <div class="row p-3 g-3">
                                                    <div class="col-4 col-lg-4 col-md-3" style="border-right: 1px solid #d6ccc2;">
                                                        3 <i class="fa-solid fa-bed" style="color: #707070;"></i>
                                                         <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                	                       Bedrooms
                                	                     </p>
                                                        
                                                    </div>
                                                    <div class="col-4 col-lg-4 col-md-3"  style="border-right: 1px solid #d6ccc2;">
                                                        2 <i class="fa-solid fa-bath" style="color: #707070;"></i>
                                                         <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                	                       Bathrooms
                                	                     </p>
                                                    </div>
                                                    <div class="col-4 col-lg-4 col-md-3"  style="border-right: 1px solid #d6ccc2;">
                                                        3450 <i class="fa-regular fa-square" style="color: #707070;"></i>
                                                         <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                	                       Squard Ft
                                	                     </p>
                                                    </div>
                                                    
                                                </div>
                                                
                                                <hr>
                                                
                                                
                                                <a href="#"  data-bs-toggle="modal" data-bs-target="#staticBackdrop" class="btn btn-warning tebHeroBtnHot btn-sm">See Property</a>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                                <div class="carousel-item">
                                     <a href="#"  data-bs-toggle="modal" data-bs-target="#staticBackdrop" style="text-decoration: none; color: black">
                                        <div class="card zoom-card" style="width: 100%; box-shadow: rgba(149, 157, 165, 0.2) 0px 8px 24px;">
                                            <div style="position: relative;">
                                                <img src="../assets/images/house2.jpg" class="card-img-top zoom" alt="...">
                                                
                                                <div class="overlay-content zoom" style="position: absolute; top: 0; left: 0; right: 0; height: 100%; background-color: rgba(0, 0, 0, 0.4); color: white; display: flex; z-index: 10; transition: transform 0.4s ease-in-out;">
                                                    <div class="status-badge" style="position: absolute; top: 10px; right: 10px; background-color: red; color: white; padding: 5px 10px; border-radius: 5px; font-size: 12px; z-index: 11;">
                                                        For Sale
                                                    </div>
                                                    <p style="padding: 20px; margin-top: 195px;"><i class="fa-solid fa-location-dot"></i> Wuse II, Abuja, Abuja FCT</p>
                                                </div>
                                            </div>
                                
                                            <div class="card-body">
                                                <h5 class="card-title mt-3" style="font-family: 'Space Grotesk' !important;">Brand New Luxury 4 Bedroom Duplex at Wuse 2</h5>
                                                
                                                <h6 class="feature-figure-text">₦ 150,000,000</h6>
                                                
                                                <p class="card-text mt-4" style="font-size: 14px; font-family: 'Space Grotesk' !important; font-weight: 400;">
                                                    Brand new Luxury 6 bedroom mansion with green area is available for sale at Katampe extension district Abuja
                                                </p>
                                                
                                                  <div class="row p-3 g-3">
                                                    <div class="col-4 col-lg-4 col-md-3" style="border-right: 1px solid #d6ccc2;">
                                                        3 <i class="fa-solid fa-bed" style="color: #707070;"></i>
                                                         <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                	                       Bedrooms
                                	                     </p>
                                                        
                                                    </div>
                                                    <div class="col-4 col-lg-4 col-md-3"  style="border-right: 1px solid #d6ccc2;">
                                                        2 <i class="fa-solid fa-bath" style="color: #707070;"></i>
                                                         <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                	                       Bathrooms
                                	                     </p>
                                                    </div>
                                                    <div class="col-4 col-lg-4 col-md-3"  style="border-right: 1px solid #d6ccc2;">
                                                        3450 <i class="fa-regular fa-square" style="color: #707070;"></i>
                                                         <p style="font-family: 'Space Grotesk' !important; color: #707070; font-weight: 300 !important; font-size: 13px;">
                                	                       Squard Ft
                                	                     </p>
                                                    </div>
                                                    
                                                </div>
                                                
                                                <hr>
                                                
                                                
                                                <a href="#"  data-bs-toggle="modal" data-bs-target="#staticBackdrop" class="btn btn-warning tebHeroBtnHot btn-sm">See Property</a>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                              </div>
                        </div>
                    </section>
            </div>
            
            
            <!--Property Purchase Modal-->
           
            
            <!-- Modal -->
            <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                         <div class="modal-header d-flex flex-column align-items-center">
                            <h1 class="modal-title fs-5 text-center" style="font-family: 'Montserrat', sans-serif; font-size: 30px !important; font-weight: 800;" id="staticBackdropLabel">
                              Get instant access to new listing
                            </h1>
                            <button type="button" class="btn-close position-absolute end-0 me-3" data-bs-dismiss="modal" aria-label="Close"></button>
                          </div>
                          <div class="modal-body">
                              <h4 class="mt-3 pl-3">Fill out the form to Proceed</h4>
                              
                                <form class="p-3 ">
                                    
                                    <div class="mb-3">
                                        <label class="form-label">Title: </label>
                                        <select class="form-select mb-3" aria-label=".form-select-lg example">
                                          <option selected>Select your Title</option>
                                          <option value="Mr">Mr</option>
                                          <option value="Mrs">Mrs</option>
                                          <option value="Miss">Miss</option>
                                          <option value="Dr">Dr</option>
                                          <option value="Prof.">Prof</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label for="name" class="form-label">First Name:</label>
                                        <input type="text" class="form-control" id="" aria-describedby="textHelp">
                                       
                                    </div>
                                    <div class="mb-3">
                                        <label for="name" class="form-label">Last Name:</label>
                                        <input type="text" class="form-control" id="" aria-describedby="textHelp">
                                       
                                    </div>
                                    <div class="mb-3">
                                        <label for="exampleInputEmail1" class="form-label">Email address</label>
                                        <input type="email" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp">
                                       
                                    </div>
                                        
                                    <div class="mb-3">
                                        <label for="phone" class="form-label">Whatsapp No.</label>
                                        <br>
                                        <input type="tel" id="phone" class="form-control" placeholder="Enter your number">
                                    </div>

                                 
                                </form>
                          </div>
                          <div class="modal-footer justify-content-center">
                            <button type="button" class="btn btn-primary reg-btn  px-4 py-2"  style="width: 100%;" data-bs-dismiss="modal">
                                Submit
                            </button>
                        </div>

                    </div>
                 </div>
            </div>

		
		</main>
		<!-- Footer Start -->
		<?php include '../includes/footer.php';?>
		<!-- Footer End -->
		
		<script>
            let currentSlide = 1;
            const totalSlides = 5;
          
            setInterval(() => {
              document.getElementById('s' + currentSlide).checked = true;
              currentSlide = currentSlide < totalSlides ? currentSlide + 1 : 1;
            }, 5000); // Change slide every 5 seconds
        </script>

        <script>
   const phoneInputField = document.querySelector("#phone");
   const phoneInput = window.intlTelInput(phoneInputField, {
      initialCountry: "ng",  // Set Nigeria as the default
      separateDialCode: true,
      utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js"
   });
</script>


	
	<!-- Js Files -->
	<!-- ============================================================== -->
	<script src="../js/global.js"></script>
	<script src="../assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>

	
</body>

</html>
